/******************************************************************************

   Esenthel Engine allows you to programatically connect to the Editor,
      and operate on projects and their elements.
      
/******************************************************************************/
Edit.EditorInterface EI; // Editor Interface, which handles connecting and exchanging data between the application and the editor

UID CurWorld=UIDZero; // current world
int LastTry=0;


Memt<Str> params;
Memc<Edit.WorldObjData> objects;
Memc<Edit.WorldObjDesc> objectsDesc;
Memt<Edit.WorldObjData> allObjects;
Memc<Edit.WorldObjDesc> targets; 
Memc<Edit.EditorInterface.Line> lines;

void InitPre()
{
   EE_INIT();
   Enums.mode(CACHE_DUMMY);   
   App.flag |= APP_WORK_IN_BACKGROUND | APP_ON_RUN_EXIT | APP_NO_PAUSE_ON_WINDOW_MOVE_SIZE ;
}
/******************************************************************************/

bool Init()
{
   // Params to look for
   params.add("OnSwitch");
   params.add("UID");
   params.add("EventGroup");
   params.add("Light");
   params.add("ObjectID");
   return true;
}
/******************************************************************************/
void Shut()
{
   // Makes sure no lines are left behind when the application closes down
   lines.clear();
   Draw();
   
   if(EI.connected())
      EI.disconnect();
}
/******************************************************************************/
bool Update()
{
   lines.clear(); // Clear the lines from the previous update
   
   if (!EI.connected())
   {
      if( (LastTry+1000) <= Time.curTimeMs())
      {         
         LastTry=Time.curTimeMs();
         Str message;
         EI.connect(message);
      }
   }
   
   if (EI.connected())
   {
      CurWorld = EI.curWorld();
      CheckReferencingTo();
      CheckReferencedBy();
      Time.wait(1000/5); // Update 5 times per second
   }
   
   if(Kb.bp(KB_ESC)) return false;
   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(BLACK);
   
   
   // If I'm not connected to the editor, I show a message //
   if( !EI.connected()) 
   {
      TextStyle  ts;
      ts.color=RED;
      ts.align.set(1, 0);
      flt y = 1;
      y -= ts.lineHeight();
      D.text( ts, -1, y, "Can't connect to Esenthel Editor." );
      y -= ts.lineHeight();
      D.text( ts, -1, y, "Please enable \"Editor Network Interface\" option in the Editor."); 
      return;
   }
   
   
   // If I'm in a world, I can do the job //
   if( IsInworld() )
   {      
      int ws = EI.worldAreaSize(CurWorld);

      TextStyle  ts;
      ts.color=WHITE;
      ts.align.set(1, 0);
      flt y = 1;
      y -= ts.lineHeight();
      D.text( ts, -1, y, S+"World Area Size : " + ws );
      y -= ts.lineHeight();
      D.text( ts, -1, y, S+"Lines number : " + lines.elms()); 
      
      EI.worldDrawLines(lines);
   } 
}
/******************************************************************************/
bool CheckReferencingTo()
{
   // Get all selected objects
   if(EI.worldObjGetData(EI.curWorld(), objects, null, null, true, false, false))
   {
      // Loop over all selected objects
      REPAD(i, objects)
      {
         Memt<UID> targetIDs;
         
         // Check every param of every object
         REPAD(j, objects[i].params)
         {
            Str sParam = objects[i].params[j].name;
            // Check every param that we defined
            REPAD(p, params)
            {
               if(Contains(sParam, params[p]))
               {
                 // Add all the valid objects to 1 list
                  targetIDs.add(objects[i].params[j].asID());              
               }
            }
         }
         
         // Get all the objects from the world, according to their ID
         if(targetIDs.elms()) EI.worldObjGetDesc(EI.curWorld(), targets, targetIDs);
         
         
         // Create lines from all objects to the eventBox
         REPAD(k, targets)
         {
            Edit.EditorInterface.Line line;
            line.set(RED, Edge(targets[k].matrix.pos, objects[i].matrix.pos));
            
            lines.add(line);
         }  
         
         targets.clear(); // Clear all targets for the next object
      }
   }
   else 
   {
      //Exit("Can no longer get objects from the scene.");
   }
   return true;
}
/******************************************************************************/
bool CheckReferencedBy()
{
   // Get all selected objects
   if(EI.worldObjGetDesc(EI.curWorld(), objectsDesc, null, null, true, false))
   {
      UID objectID;
      // Loop over all selected objects
      REPAD(i, objectsDesc)
      {
         objectID = objectsDesc[i].instance_id;
      }
         
     
      // Get all objects in the scene
      if(EI.worldObjGetData(EI.curWorld(), allObjects))
      {
         REPAD(a, allObjects)
         {
            // Check every param of every object
            REPAD(j, allObjects[a].params)
            {
               // Param is an ID
               UID ID = allObjects[a].params[j].asID();
               if(ID == objectID)
               {
                  Edit.EditorInterface.Line line;
                  line.set(GREEN, Edge(allObjects[a].matrix.pos, objectsDesc[0].matrix.pos));
                  
                  lines.add(line);
               }
            }
         }  
      }
      else 
      {  
         //Exit("Can no longer get objects from the scene.");
      }
      allObjects.del();    
   }
   
   return true;
}
/******************************************************************************/
bool IsInworld()
{   
   return ( CurWorld != UIDZero );
}
/******************************************************************************/